/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.math;

import icyllis.modernui.math.MathUtil;
import icyllis.modernui.math.Matrix4;
import icyllis.modernui.math.Quaternion;
import javax.annotation.Nonnull;

public class Vector3 {
    public float x;
    public float y;
    public float z;

    public Vector3() {
    }

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(@Nonnull Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void add(@Nonnull Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void subtract(@Nonnull Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void multiply(float s2) {
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
    }

    public void multiply(float mx, float my, float mz) {
        this.x *= mx;
        this.y *= my;
        this.z *= mz;
    }

    public void multiply(@Nonnull Vector3 v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
    }

    public float length() {
        return MathUtil.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float dot(@Nonnull Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public void cross(float x, float y, float z) {
        float f = this.y * z - this.z * y;
        float g2 = this.z * x - this.x * z;
        float h2 = this.x * y - this.y * x;
        this.x = f;
        this.y = g2;
        this.z = h2;
    }

    public void cross(@Nonnull Vector3 v) {
        if (this == v) {
            this.setZero();
            return;
        }
        float x = this.y * v.z - this.z * v.y;
        float y = this.z * v.x - this.x * v.z;
        float z = this.x * v.y - this.y * v.x;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void minComponent(@Nonnull Vector3 v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        this.z = Math.min(this.z, v.z);
    }

    public void maxComponent(@Nonnull Vector3 v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        this.z = Math.max(this.z, v.z);
    }

    public boolean isNormalized() {
        return MathUtil.approxEqual(this.lengthSquared(), 1.0f);
    }

    public void normalize() {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            this.x = 1.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            float invNorm = 1.0f / MathUtil.sqrt(sq);
            this.x *= invNorm;
            this.y *= invNorm;
            this.z *= invNorm;
        }
    }

    public void normalizeFast() {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            this.x = 1.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            float invNorm = MathUtil.fastInvSqrt(sq);
            this.x *= invNorm;
            this.y *= invNorm;
            this.z *= invNorm;
        }
    }

    public void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public float sum() {
        return this.x + this.y + this.z;
    }

    public float product() {
        return this.x * this.y * this.z;
    }

    public void perpendicular() {
        if (Math.abs(this.x) >= Math.abs(this.y)) {
            float l = 1.0f / MathUtil.sqrt(this.x * this.x + this.z * this.z);
            float t = this.x;
            this.x = -this.z * l;
            this.y = 0.0f;
            this.z = t * l;
        } else {
            float l = 1.0f / MathUtil.sqrt(this.y * this.y + this.z * this.z);
            float t = this.y;
            this.x = 0.0f;
            this.y = this.z * l;
            this.z = -t * l;
        }
    }

    public void projection(@Nonnull Vector3 v) {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            this.setZero();
        } else {
            float c = this.dot(v) / MathUtil.sqrt(sq);
            this.x = v.x * c;
            this.y = v.y * c;
            this.z = v.z * c;
        }
    }

    @Nonnull
    public Quaternion rotation(float angle) {
        return Quaternion.makeAxisAngle(this, angle);
    }

    public void transform(@Nonnull Matrix4 mat) {
        mat.transform(this);
    }

    public void preTransform(@Nonnull Matrix4 mat) {
        mat.preTransform(this);
    }

    public void transform(@Nonnull Quaternion q) {
        float f = q.y * this.z - q.z * this.y + q.w * this.x;
        float g2 = q.z * this.x - q.x * this.z + q.w * this.y;
        float h2 = q.x * this.y - q.y * this.x + q.w * this.z;
        this.x += (q.y * h2 - q.z * g2) * 2.0f;
        this.y += (q.z * f - q.x * h2) * 2.0f;
        this.z += (q.x * g2 - q.y * f) * 2.0f;
    }

    public void sort() {
        float t;
        if (this.x > this.y) {
            t = this.x;
            this.x = this.y;
            this.y = t;
        }
        if (this.y > this.z) {
            t = this.y;
            this.y = this.z;
            this.z = t;
        }
        if (this.x > this.y) {
            t = this.x;
            this.x = this.y;
            this.y = t;
        }
    }

    public void reverse() {
        float t = this.x;
        this.x = this.z;
        this.z = t;
    }

    public boolean equivalent(@Nonnull Vector3 v) {
        if (this == v) {
            return true;
        }
        return MathUtil.approxEqual(this.x, v.x) && MathUtil.approxEqual(this.y, v.y) && MathUtil.approxEqual(this.z, v.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)o;
        if (!MathUtil.exactlyEqual(vector3.x, this.x)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(vector3.y, this.y)) {
            return false;
        }
        return MathUtil.exactlyEqual(vector3.z, this.z);
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
        return result;
    }

    public String toString() {
        return "Vector3[" + this.x + ", " + this.y + ", " + this.z + ']';
    }

    @Nonnull
    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }
}

